{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:13:56 $                                        =}
{========================================================================}
unit mixer_fmProps;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMMixer, StdCtrls, MMMixCtl, MMDesign, MMSpin, ExtCtrls, ComCtrls,
  MMDevice, MMUtils, MMHook, ImgList, BusinessSkinForm;

type
  TPropertiesForm = class(TForm)
    MixerDevice1: TMMMixerDevice;
    MMDesigner1: TMMDesigner;
    RadioGroup1: TRadioGroup;
    ComboBox1: TComboBox;
    Button1: TButton;
    Button2: TButton;
    AudioLine1: TMMAudioLine;
    ListView1: TListView;
    ImageList1: TImageList;
    AudioLine2: TMMAudioLine;
    MixerControl1: TMMMixerControl;
    MMDeviceComboBox1: TMMDeviceComboBox;
    Label1: TLabel;
    Label2: TLabel;
    bsBusinessSkinForm1: TbsBusinessSkinForm;
    procedure RadioGroup1Click(Sender: TObject);
    procedure MixerDevice1Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ListView1Click(Sender: TObject);
    procedure ListView1MouseDown(Sender: TObject; Button: TMouseButton;
                                 Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FOldRadioIndex: integer;
    FOldComboIndex: integer;

    procedure   InitDestinations;
    procedure   UpdateConnections;
    procedure   UpdateComboBox;

    function    RegIsLineEnabled(Index : Integer): Boolean;
    procedure   RegSaveLines;
    function    CurrentKey : string;
    function    RegIsAdditionalProps : Boolean;
    procedure   RegSetAdditionalProps(Value : Boolean);
  public
    { Public declarations }
    procedure   GetCurrentLines(Lines : TList);
    function    GetCurrentDestination : TMMLineId;
    function    IsSelected(Index : Integer) : Boolean;
    function    Execute: Boolean;
    property    ShowAdditional: Boolean read RegIsAdditionalProps write RegSetAdditionalProps;
  end;

var
  PropertiesForm: TPropertiesForm;

implementation

{$R *.DFM}

uses
    MMSystem, Registry, mixer_fmMain;

const
    AppKey = 'Software\Microsoft\Windows\CurrentVersion\Applets\Volume Control';

type
    PLineRecA = ^TLineRecA;
    TLineRecA = packed record
        Flags : DWord;
        Name  : array[0..MIXER_LONG_NAME_CHARS-1] of Char;
    end;

    PLineRecW = ^TLineRecW;
    TLineRecW = packed record
        Flags : DWord;
        Name  : array[0..MIXER_LONG_NAME_CHARS-1] of WideChar;
    end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.RadioGroup1Click(Sender: TObject);
begin
   UpdateComboBox;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.UpdateComboBox;
begin
   RadioGroup1.Controls[2].Enabled := ComboBox1.Items.Count > 0;
   ComboBox1.Enabled := (RadioGroup1.ItemIndex = 2) and (ComboBox1.Items.Count > 0);
   if ComboBox1.Enabled then
      ComboBox1.Color := clWindow
   else
      ComboBox1.Color := clLtGray;
   UpdateConnections;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.UpdateConnections;
var
   i: Integer;
   Lines: TList;

   procedure AddItem(Id: TMMLineId);
   begin
      AudioLine2.LineId := Id;
      if Id <> badLineId then
      with ListView1.Items.Add do
      begin
         Caption    := AudioLine2.LineInfo.Name;
         StateIndex := Ord(RegIsLineEnabled(i));
      end;
   end;

begin
   case RadioGroup1.ItemIndex of
        0 : AudioLine1.ComponentType := ctDstSpeakers;
        1 : AudioLine1.ComponentType := ctDstWaveIn;
        2 : with ComboBox1 do
                if Items.Count > 0 then
                    AudioLine1.LineId := TMMLineId(Items.Objects[ItemIndex]);
                else
                    AudioLine1.LineId := badLineId;
    end;
    ListView1.Items.Clear;
    Lines := TList.Create;
    try
       GetCurrentLines(Lines);
       for i := 0 to Lines.Count - 1 do
           AddItem(TMMLineId(Lines[i]));
    finally
       Lines.Free;
    end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.MixerDevice1Change(Sender: TObject);
begin
   InitDestinations;
   UpdateComboBox;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure   TPropertiesForm.InitDestinations;
var
   i: Integer;
begin
   ComboBox1.Clear;
   for i := 0 to MixerDevice1.Destinations - 1 do
   with AudioLine1 do
   begin
      LineId := MixerDevice1.Destination[i];
      if LineId <> badLineId then
         if (ComponentType <> ctDstSpeakers) and (ComponentType <> ctDstWaveIn) then
             ComboBox1.Items.AddObject(LineInfo.Name, TObject(LineId));
   end;
   ComboBox1.ItemIndex := ComboBox1.Items.Count - 1;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.ComboBox1Change(Sender: TObject);
begin
   UpdateConnections;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.GetCurrentLines(Lines: TList);
var
    i : Integer;
begin
   Lines.Clear;
   if AudioLine1.LineId <> badLineId then
   begin
      Lines.Add(Pointer(AudioLine1.LineId));

      for i := 0 to AudioLine1.Connections - 1 do
          Lines.Add(Pointer(TMMLineId(AudioLine1.Connection[i])));
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
function TPropertiesForm.GetCurrentDestination : TMMLineId;
begin
   Result := AudioLine1.LineId;
end;

{-- TPropertiesForm ------------------------------------------------------}
function TPropertiesForm.Execute: Boolean;
begin
   MixerDevice1.DeviceID := MixerMainForm.MixerDevice1.DeviceID;
   FOldRadioIndex        := RadioGroup1.ItemIndex;
   FOldComboIndex        := ComboBox1.ItemIndex;
   Result := ShowModal = mrOk;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.FormCreate(Sender: TObject);
begin
   InitDestinations;
   UpdateComboBox;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.ListView1Click(Sender: TObject);
var
   i: integer;
   OK_Enabled: Boolean;
begin
   Button1.Enabled := ListView1.Selected <> nil;
   if ListView1.Selected <> nil then
      ListView1.Selected.StateIndex := 1 - ListView1.Selected.StateIndex;

   OK_Enabled := False;
   for i := 0 to ListView1.Items.Count-1 do
   begin
      if IsSelected(i) then
      begin
         OK_Enabled := True;
         break;
      end;
   end;
   Button1.Enabled := OK_Enabled;
end;

{-- TPropertiesForm ------------------------------------------------------}
function TPropertiesForm.IsSelected(Index : Integer) : Boolean;
begin
    Result := ListView1.Items[Index].StateIndex = 1;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.ListView1MouseDown(Sender: TObject; Button: TMouseButton;
                                             Shift: TShiftState; X, Y: Integer);
var
   Item: TListItem;
begin
   Item := ListView1.GetItemAt(X,Y);
   if (Item <> nil) then
   begin
      Item.Selected := True;
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.FormShow(Sender: TObject);
begin
   RadioGroup1Click(RadioGroup1);
end;

{-- TPropertiesForm ------------------------------------------------------}
function TPropertiesForm.CurrentKey: string;
begin
   Result := AppKey + '\' +
             MixerDevice1.DeviceCaps.ProductName + '\' +
             AudioLine1.LineInfo.ShortName;
end;

{-- TPropertiesForm ------------------------------------------------------}
function    TPropertiesForm.RegIsLineEnabled(Index : Integer) : Boolean;
var
    Size : Integer;
    Data : Pointer;
    PA   : PLineRecA;
    PW   : PLineRecW;
begin
   with TRegistry.Create do
   try
      RootKey := HKEY_CURRENT_USER;
      OpenKey(Self.CurrentKey, True);
      try
         Size := GetDataSize('LineStates');
         if ((_WinNT3_ or _WINNT4_) and (Size < SizeOf(PW^) * (Index + 1))) or
             ((_Win95_ or _Win98_) and (Size < SizeOf(PA^) * (Index + 1))) then
              Result := True
         else
         begin
            GetMem(Data,Size);
            try
               ReadBinaryData('LineStates',Data^,Size);
               if not (_Win95_ or _Win98_) then
               begin
                  PW := Data;
                  Inc(Pa,Index);
                  //Result := PW^.Flags = 0;
                  result:=true;
               end
               else
               begin
                  PA := Data;
                  Inc(PA,Index);
                  Result := PA^.Flags = 0;
               end;

            finally
               FreeMem(Data,Size);
            end;
         end;

      finally
         CloseKey;
      end;

   finally
      Free;
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.RegSaveLines;
var
   Size  : Integer;
   Data  : Pointer;
   PA    : PLineRecA;
   PW    : PLineRecW;
   i     : Integer;
   Name  : string;
   Value : DWord;
begin
   with TRegistry.Create do
   try
      RootKey := HKEY_CURRENT_USER;
      OpenKey(Self.CurrentKey, True);
      try
         if not (_Win95_ or _Win98_) then
            Size := SizeOf(PW^) * ListView1.Items.Count
         else
            Size := SizeOf(PA^) * ListView1.Items.Count;

         PA := nil;
         PW := nil;

         GetMem(Data,Size);
         try
            FillChar(Data^,Size,0);
            if not (_Win95_ or _Win98_) then
               PW := Data
            else
               PA := Data;

            for i := 0 to ListView1.Items.Count - 1 do
            begin
               Name := ListView1.Items[i].Caption;
               if not (_Win95_ or _Win98_) then
                  StringToWideChar(Name, PW^.Name, SizeOf(PW^.Name))
               else
                  StrPCopy(PA^.Name, Name);

               if IsSelected(i) then
                  Value := 0
               else
                  Value := 4; {?}

               if not (_Win95_ or _Win98_) then
               begin
                  PW^.Flags := Value;
                  Inc(PW);
               end
               else
               begin
                  PA^.Flags := Value;
                  Inc(PA);
               end;
            end;
            WriteBinaryData('LineStates',Data^,Size);

         finally
            FreeMem(Data,Size);
         end;

      finally
         CloseKey;
      end;

   finally
      Free;
   end;
end;

const
    AdditionalMask = $800;

{-- TPropertiesForm ------------------------------------------------------}
function TPropertiesForm.RegIsAdditionalProps : Boolean;
begin
   with TRegistry.Create do
   try
      RootKey := HKEY_CURRENT_USER;
      OpenKey(AppKey + '\Options', True);
      try
         Result := not ValueExists('Style') or ((ReadInteger('Style') and AdditionalMask) <> 0);
      finally
         CloseKey;
      end;
   finally
      Free;
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.RegSetAdditionalProps(Value: Boolean);
var
    Val: Integer;
begin
   with TRegistry.Create do
   try
      RootKey := HKEY_CURRENT_USER;
      OpenKey(AppKey + '\Options', True);
      try
         Val := ReadInteger('Style');
         if Value then
            Val := Val or AdditionalMask
         else
            Val := Val and not AdditionalMask;
         WriteInteger('Style', Val);
      finally
         CloseKey;
      end;
   finally
      Free;
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.Button1Click(Sender: TObject);
begin
   try
      RegSaveLines;
      MixerMainForm.MixerDevice1.DeviceID := MixerDevice1.DeviceID;
      ModalResult := mrOk;
   except
      on E : Exception do
         MessageDlg(E.Message,mtError,[mbOk],0);
   end;
end;

{-- TPropertiesForm ------------------------------------------------------}
procedure TPropertiesForm.Button2Click(Sender: TObject);
begin
   MixerDevice1.DeviceID := MixerMainForm.MixerDevice1.DeviceID;
   RadioGroup1.ItemIndex := FOldRadioIndex;
   ComboBox1.ItemIndex   := FOldComboIndex;
   UpdateComboBox;
end;

end.
